# Amaze

A maze generator written in Mercury that produces SVG output. Supports multiple maze generation algorithms and both square and hexagonal grid topologies.

🤖 Generated with [Claude Code](https://claude.ai/code)

Co-authored-by: Claude <noreply@anthropic.com>

## Build

Requires the [Mercury](https://mercurylang.org/) compiler.

```sh
mmc --make amaze
```

## Usage

```
amaze [options] [output.svg]
```

### Input Options

| Option | Description |
|--------|-------------|
| `-t, --topology <square\|hex>` | Grid topology (default: square) |
| `-s, --size <N\|WxH>` | Maze size (default: 10) |
| `-r, --random-seed <N>` | Random seed (default: system time) |
| `-e, --entrance-offset <N>` | Entrance offset from centre (default: 0) |
| `-x, --exit-offset <N>` | Exit offset from centre (default: entrance offset) |
| `-a, --algorithm <name>` | Maze generation algorithm (default: kruskal) |

### Algorithms

| Algorithm | Square | Hex | Description |
|-----------|--------|-----|-------------|
| `dfs` | Yes | Yes | Depth-first search (recursive backtracker) |
| `binary-tree` | Yes | No | Binary tree algorithm |
| `sidewinder` | Yes | No | Sidewinder algorithm |
| `hunt-and-kill` | Yes | Yes | Hunt and kill algorithm |
| `aldous-broder` | Yes | Yes | Aldous-Broder random walk |
| `wilson` | Yes | Yes | Wilson's loop-erased random walk |
| `kruskal` | Yes | Yes | Kruskal's algorithm (randomized) |
| `prim` | Yes | Yes | Prim's algorithm (randomized) |

### Output Options

| Option | Description |
|--------|-------------|
| `--cell-spacing <N>` | Cell spacing in viewbox units (default: 10) |
| `--margin <N>` | Margin in multiples of cell spacing (default: 2) |
| `-p, --path` | Display the solution path |
| `--maze-bg-color <color>` | Maze background color (default: none) |
| `--cell-bg-color <color>` | Cell background color (default: white) |
| `--internal-wall-color <color>` | Internal wall color (default: black) |
| `--boundary-wall-color <color>` | Boundary wall color (default: black) |
| `--path-color <color>` | Solution path color (default: red) |
| `--internal-wall-width <N>` | Internal wall stroke width (default: 1) |
| `--boundary-wall-width <N>` | Boundary wall stroke width (default: 2) |
| `--path-width <N>` | Solution path stroke width (default: 3) |

Color values are passed through to SVG without validation. Valid formats include named colors (`red`), hex (`#ff0000`), and rgb (`rgb(255,0,0)`).

### General Options

| Option | Description |
|--------|-------------|
| `-h, --help` | Display help |
| `-d, --dump` | Dump maze structure to stdout |

### Examples

Generate a 15x15 square maze:
```sh
./amaze --size 15 maze.svg
```

Generate a hexagonal maze with solution path:
```sh
./amaze --topology hex --size 7 --path maze.svg
```

Generate a styled maze:
```sh
./amaze --size 10 --path \
    --maze-bg-color lightgray \
    --boundary-wall-color navy \
    --internal-wall-color steelblue \
    --path-color orange \
    maze.svg
```

## Design Features

### Topology Abstraction

The maze generator cleanly separates grid topology from maze generation algorithms. The `topology` type (`square` or `hex`) determines cell adjacency, coordinate systems, and rendering geometry, while the generation algorithms operate on abstract cells and edges. This allows most algorithms to work unchanged on both grid types.

### Boundary Wall Traversal

Entrance and exit positions are specified as offsets along the boundary perimeter rather than absolute coordinates. The boundary module generates a clockwise sequence of all boundary walls, allowing flexible placement of openings regardless of grid topology. This approach naturally handles the irregular boundary shape of hexagonal mazes.

### Uniform Random Spanning Trees

The Aldous-Broder and Wilson algorithms generate uniformly random spanning trees, meaning every possible maze is equally likely. Wilson's algorithm achieves this efficiently through loop-erased random walks, while Aldous-Broder uses a simpler but slower pure random walk.

### SVG Rendering with Polylines

Boundary walls are rendered as two polylines (from entrance to exit and back) rather than individual line segments. This produces cleaner SVG output with proper line joins at corners and ensures the boundary appears as a continuous path with gaps only at the entrance and exit.

## Statistics

| Metric | Count |
|--------|-------|
| Total lines of code | 3,636 |
| Modules | 17 |
| Type definitions | 14 |
| Predicate declarations | 84 |
| Function declarations | 44 |

### Lines by Module

| Module | Lines | Description |
|--------|-------|-------------|
| render.m | 755 | SVG rendering |
| options.m | 447 | Command-line parsing |
| maze.m | 312 | Maze data structure |
| boundary.m | 295 | Boundary wall traversal |
| grid.m | 226 | Grid geometry |
| generate.kruskal.m | 182 | Kruskal's algorithm |
| generate.wilson.m | 178 | Wilson's algorithm |
| generate.sidewinder.m | 160 | Sidewinder algorithm |
| amaze.m | 151 | Main module |
| check.m | 150 | Maze validation |
| generate.hunt_and_kill.m | 141 | Hunt and kill algorithm |
| generate.prim.m | 126 | Prim's algorithm |
| dump.m | 112 | Debug output |
| generate.binary_tree.m | 108 | Binary tree algorithm |
| generate.m | 106 | Generate dispatcher |
| generate.aldous_broder.m | 100 | Aldous-Broder algorithm |
| generate.dfs.m | 87 | DFS algorithm |

## License

Copyright (c) 2024 Mark Brown.

This work is licensed under the [Creative Commons Attribution-ShareAlike 4.0 International License](https://creativecommons.org/licenses/by-sa/4.0/).
